/*
 * Decompiled with CFR 0.152.
 */
package snownee.companion;

import com.google.common.collect.Lists;
import com.lizin5ths.indypets.util.IndyPetsUtil;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.dimension.v1.FabricDimensions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1350;
import net.minecraft.class_14;
import net.minecraft.class_1432;
import net.minecraft.class_1439;
import net.minecraft.class_1496;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4135;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_5568;
import net.minecraft.class_5819;
import net.minecraft.class_6025;
import net.minecraft.class_6862;
import net.minecraft.class_7;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import snownee.companion.Companion;
import snownee.companion.CompanionCommonConfig;
import snownee.companion.CompanionTeleporter;
import snownee.companion.mixin.EntityAccess;
import snownee.companion.mixin.MobAccess;

public class Hooks {
    public static final class_6862<class_1792> RANGED_WEAPON = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("companion", "ranged_weapon"));
    public static final class_6862<class_1792> CHARGED_RANGED_WEAPON = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("companion", "charged_ranged_weapon"));
    public static final Object2BooleanMap<Class<?>> FOLLOWABLE_CACHE = new Object2BooleanOpenHashMap();
    public static boolean traveling;
    public static boolean indyPets;

    public static void changeDimension(class_3222 player, class_3218 to, class_3218 from, boolean returnFromEnd) {
        if (player.method_7325() || player.method_29504()) {
            return;
        }
        if (returnFromEnd ? player.method_37908() != from : player.method_37908() != to) {
            return;
        }
        boolean nether = from.method_27983() == class_1937.field_25180 || to.method_27983() == class_1937.field_25180;
        class_2338 portalPos = null;
        if (nether && (portalPos = ((EntityAccess)player).getPortalEntrancePos()) == null) {
            return;
        }
        for (class_1297 entity : Hooks.getAllPets(from, player)) {
            if (nether) {
                ((EntityAccess)entity).setPortalCooldown(0);
                ((EntityAccess)entity).callHandleInsidePortal(portalPos);
            }
            entity.method_30229();
            class_5454 portal = CompanionTeleporter.INSTANCE.getPortalInfo(entity, to, null);
            if (portal == null) continue;
            FabricDimensions.teleport((class_1297)entity, (class_3218)to, (class_5454)portal);
        }
    }

    public static List<class_1297> getAllPets(class_3218 level, class_3222 player) {
        int max = CompanionCommonConfig.portalMaxTeleportedPets;
        if (max == -1) {
            max = level.method_8450().method_8356(class_1928.field_19405);
        }
        traveling = true;
        ArrayList entities = Lists.newArrayList();
        for (class_1297 entity : level.method_27909()) {
            if (entities.size() >= max) break;
            if (entity.method_5765() || !entity.method_5822() || !(entity instanceof class_1308)) continue;
            class_1308 mob = (class_1308)entity;
            if (mob.method_5934()) {
                if (mob.method_5933() != player) continue;
                entities.add(mob);
                continue;
            }
            if (!Objects.equals(player.method_5667(), Hooks.getEntityOwnerUUID((class_1297)mob)) || !Hooks.shouldFollowOwner((class_1309)player, mob)) continue;
            entities.add(mob);
        }
        traveling = false;
        return entities;
    }

    public static Optional<class_243> teleportWithRandomOffset(class_1309 entity, class_1937 level, class_2338 blockPos, Boolean canFly, class_1297 avoidColliding) {
        class_238 box;
        boolean _canFly = canFly != null ? canFly : entity instanceof class_1432;
        Optional<class_243> vec3 = Hooks.teleportWithRandomOffsetInternal(entity, level, blockPos, _canFly, box = avoidColliding.method_5829());
        if (vec3.isPresent() || _canFly) {
            return vec3;
        }
        class_2338 heightmapPos = level.method_8598(class_2902.class_2903.field_13197, blockPos);
        if (heightmapPos.method_10264() < blockPos.method_10264()) {
            return Hooks.teleportWithRandomOffsetInternal(entity, level, heightmapPos, false, box);
        }
        class_2338.class_2339 mutable = blockPos.method_25503().method_10098(class_2350.field_11033);
        for (int i = 0; i < 25; ++i) {
            mutable.method_10098(class_2350.field_11033);
            class_2680 blockState = level.method_8320((class_2338)mutable);
            if (!class_2902.class_2903.field_13197.method_16402().test(blockState)) continue;
            return Hooks.teleportWithRandomOffsetInternal(entity, level, (class_2338)mutable, false, box);
        }
        return Optional.empty();
    }

    private static Optional<class_243> teleportWithRandomOffsetInternal(class_1309 entity, class_1937 level, class_2338 blockPos, boolean canFly, class_238 avoidColliding) {
        if (entity.method_37908() == level && blockPos.method_19770((class_2374)entity.method_19538()) < 16.0) {
            return Optional.empty();
        }
        class_5819 random = entity.method_6051();
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int i = 0; i < 25; ++i) {
            int j = Hooks.randomIntInclusive(random, -3, 3);
            int l = Hooks.randomIntInclusive(random, -3, 3);
            if (Math.abs(j) + Math.abs(l) < 2) continue;
            int k = Hooks.randomIntInclusive(random, -1, 1);
            pos.method_10103(blockPos.method_10263() + j, blockPos.method_10264() + k, blockPos.method_10260() + l);
            if (!Hooks.canTeleportTo(entity, level, (class_2338)pos, canFly, avoidColliding)) continue;
            return Optional.of(new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5));
        }
        return Optional.empty();
    }

    private static int randomIntInclusive(class_5819 random, int i, int j) {
        return random.method_43048(j - i + 1) + i;
    }

    private static boolean canTeleportTo(class_1309 entity, class_1937 level, class_2338 blockPos, boolean canFly, class_238 avoidColliding) {
        class_2338.class_2339 mutable = blockPos.method_25503();
        class_7 blockPathType = class_14.method_23476((class_1922)level, (class_2338.class_2339)mutable);
        if (blockPathType == class_7.field_7 && !canFly) {
            return false;
        }
        if (entity instanceof class_1314) {
            class_1314 pathfinderMob = (class_1314)entity;
            float f = pathfinderMob.method_6149(blockPos);
            if (blockPathType == class_7.field_18) {
                if (f > class_7.field_18.method_11()) {
                    return false;
                }
                mutable.method_10098(class_2350.field_11036);
                class_2680 aboveState = level.method_8320((class_2338)mutable);
                if (!aboveState.method_26215()) {
                    return false;
                }
            } else if (blockPathType == class_7.field_14 || blockPathType == class_7.field_3 || blockPathType == class_7.field_9 ? !entity.method_5753() : blockPathType != class_7.field_12 && blockPathType != class_7.field_7) {
                return false;
            }
        } else if (blockPathType != class_7.field_12 && blockPathType != class_7.field_7) {
            return false;
        }
        class_2338 blockPos2 = blockPos.method_10059((class_2382)entity.method_24515());
        class_238 moved = entity.method_5829().method_989((double)blockPos2.method_10263() + 0.5, (double)blockPos2.method_10264(), (double)blockPos2.method_10260() + 0.5);
        return !moved.method_994(avoidColliding) && level.method_8587((class_1297)entity, moved);
    }

    public static boolean wantsToAttack(class_1321 pet, class_1309 enemy) {
        if (CompanionCommonConfig.petWontAttackWhenInjured && Hooks.isInjured((class_1309)pet)) {
            return !(enemy instanceof class_1569) && !(enemy instanceof class_1439);
        }
        return true;
    }

    public static boolean isInjured(class_1309 entity) {
        return entity.method_6032() < entity.method_6063() && entity.method_6032() / entity.method_6063() <= CompanionCommonConfig.petInjuredStatusHealthRatio;
    }

    public static void handleChunkPreUnload(List<class_5568> entities) {
        for (class_5568 entityAccess : entities) {
            class_1308 entity;
            class_1657 owner;
            if (!(entityAccess instanceof class_1308) || !Hooks.shouldFollowOwner((class_1309)(owner = Hooks.getEntityOwner((class_1297)(entity = (class_1308)entityAccess))), entity) || owner.method_37908() != entity.method_37908()) continue;
            class_2338 pos = owner.method_24515();
            Hooks.teleportWithRandomOffset((class_1309)entity, owner.method_37908(), pos, null, (class_1297)owner).ifPresentOrElse(vec -> entity.method_5859(vec.field_1352, vec.field_1351, vec.field_1350), () -> {
                if (!entity.method_6082((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), false) && CompanionCommonConfig.logIfTeleportingFailed) {
                    Companion.LOGGER.warn("Failed to teleport {}({}) from {} {} to {}", new Object[]{entity.method_5476().getString(), class_7923.field_41177.method_10221((Object)entity.method_5864()), entity.method_37908().method_27983().method_29177(), entity.method_24515().method_23854(), pos.method_23854()});
                }
            });
        }
    }

    public static boolean shouldFollowOwner(class_1309 owner, class_1308 pet) {
        if (owner == null || owner.method_29504() || owner.method_7325() || pet.method_5934() || pet.method_5765()) {
            return false;
        }
        if (pet instanceof class_1321) {
            class_1321 animal = (class_1321)pet;
            if (animal.method_24345()) {
                return false;
            }
            if (indyPets && IndyPetsUtil.isIndependent((class_1321)animal)) {
                return false;
            }
        }
        if (pet instanceof class_1496) {
            return pet.method_37908().method_8450().method_8355(Companion.ALWAYS_TELEPORT_HORSES);
        }
        return FOLLOWABLE_CACHE.computeIfAbsent(pet.getClass(), $ -> {
            for (class_4135 goal : ((MobAccess)pet).getGoalSelector().method_35115()) {
                if (!(goal.method_19058() instanceof class_1350)) continue;
                return true;
            }
            return false;
        });
    }

    public static boolean isHoldingRangedWeapon(class_3222 player) {
        class_1799 stack;
        class_1839 anim;
        if (player.method_24520($ -> $.method_31573(RANGED_WEAPON))) {
            class_1799 stack2;
            class_1799 main = player.method_6047();
            class_1799 off = player.method_6079();
            class_1799 class_17992 = stack2 = main.method_31573(RANGED_WEAPON) ? main : off;
            if (stack2.method_7909() instanceof class_1764) {
                if (class_1764.method_7781((class_1799)stack2)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return player.method_6115() && player.method_6014() > 0 && player.method_24520($ -> $.method_31573(CHARGED_RANGED_WEAPON)) && ((anim = (stack = player.method_6030()).method_7976()) == class_1839.field_8953 || anim == class_1839.field_8947 || anim == class_1839.field_8951);
    }

    @Nullable
    public static class_1657 getEntityOwner(class_1297 entity) {
        UUID ownerUUID = Hooks.getEntityOwnerUUID(entity);
        if (ownerUUID == null) {
            return null;
        }
        if (entity.method_37908().method_8503() == null) {
            return entity.method_37908().method_18470(ownerUUID);
        }
        return entity.method_37908().method_8503().method_3760().method_14602(ownerUUID);
    }

    @Nullable
    public static UUID getEntityOwnerUUID(class_1297 entity) {
        if (entity instanceof class_6025) {
            return ((class_6025)entity).method_6139();
        }
        return null;
    }

    static {
        indyPets = FabricLoader.getInstance().isModLoaded("indypets");
    }
}

